const wrapper = document.querySelector(".wrapper"),
qrInput = wrapper.querySelector(".form input"),
generateBtn = wrapper.querySelector(".form button"), 
qrImg = wrapper.querySelector(".qr-code img");
let preValue;

// Initialize Download button
downloadBtn.innerText = "Download QR Code";
downloadBtn.style.display = "none"; // Hidden by default
downloadBtn.className = "primary-btn"; // Apply the primary button styling
wrapper.appendChild(downloadBtn); // Append it to the wrapper

generateBtn.addEventListener("click", () => {
    let qrValue = qrInput.value.trim();
    if (!qrValue || preValue === qrValue) return; // Prevent duplicate generation
    preValue = qrValue;
    generateBtn.innerText = "Generating QR Code...";
    qrImg.src = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${qrValue}`;
    
    // Once the image is fully loaded
    qrImg.addEventListener("load", () => {
        wrapper.classList.add("active");
        generateBtn.innerText = "Generate QR Code";
        downloadBtn.style.display = "block"; // Show the Download button
    });
});

// Download button functionality
downloadBtn.addEventListener("click", () => {
    const link = document.createElement("a");
    link.href = qrImg.src; // Use the QR code image source
    link.download = "QRCode.png"; // Specify the file name
    link.click(); // Trigger the download
});

qrInput.addEventListener("keyup", () => {
    if (!qrInput.value.trim()) {
        wrapper.classList.remove("active");
        preValue = "";
        downloadBtn.style.display = "none"; // Hide the Download button
    }
});
